PRO FIND_LET_FACTORS_FILES, SCid, tai_time, FACTORS_FILENM, SECTORED_FACTORS_FILENM, need_to_read, sectored_need_to_read

; Figure out which LET Level 1 factors files to read in, if any
; 
; May 29, 2007: Andrew Davis, Caltech. Copied from SEP Beacon software version, with slight edits
;	and addition of code for sectored caldb

common let_l1

IF (first_frame eq 1) THEN BEGIN
   read_let_l1_caldb
ENDIF

; First check the unsectored database
IF (SCid eq 235) then BEGIN
   FOR ii=0, caln_b -1 DO BEGIN
      IF (tai_time lt caltimes_b[ii]) THEN BEGIN
         factors_filenm = concat_dir('$LET_L1_CALIB_DATA' , calfnames_b[ii])
         break
      ENDIF
   ENDFOR
   IF (ii eq caln_b) THEN BEGIN
      printf, -2, 'Warning: timestamp beyond end of Behind LET caldb: Using Last Behind LET factors file'
      factors_filenm = concat_dir('$LET_L1_CALIB_DATA' , calfnames_b[caln_b -1])
   ENDIF
ENDIF ELSE BEGIN 
   FOR ii=0, caln_a -1 DO BEGIN
      IF (tai_time lt caltimes_a[ii]) THEN BEGIN
         factors_filenm = concat_dir('$LET_L1_CALIB_DATA' , calfnames_a[ii])
         break
      ENDIF
   ENDFOR
   IF (ii eq caln_a) THEN BEGIN
      printf, -2, 'Warning: timestamp beyond end of Ahead LET caldb: Using Last Ahead LET factors file'
      factors_filenm = concat_dir('$LET_L1_CALIB_DATA' , calfnames_a[caln_a -1])
   ENDIF
   IF (SCid ne 234) then BEGIN 
      printf, -2, 'Warning: Bad SCid:', SCid, '   Using Ahead LET factors file'
   ENDIF 
ENDELSE 

; Now check the sectored database
IF (SCid eq 235) then BEGIN
   FOR ii=0, sec_caln_b -1 DO BEGIN
      IF (tai_time lt sec_caltimes_b[ii]) THEN BEGIN
         sectored_factors_filenm = concat_dir('$LET_L1_CALIB_DATA' , sec_calfnames_b[ii])
         break
      ENDIF
   ENDFOR
   IF (ii eq sec_caln_b) THEN BEGIN
      printf, -2, 'Warning: timestamp beyond end of Behind LET sectored caldb: Using Last Behind LET sectored factors file'
      sectored_factors_filenm = concat_dir('$LET_L1_CALIB_DATA' , sec_calfnames_b[sec_caln_b -1])
   ENDIF
ENDIF ELSE BEGIN 
   FOR ii=0, sec_caln_a -1 DO BEGIN
      IF (tai_time lt sec_caltimes_a[ii]) THEN BEGIN
         sectored_factors_filenm = concat_dir('$LET_L1_CALIB_DATA' , sec_calfnames_a[ii])
         break
      ENDIF
   ENDFOR
   IF (ii eq sec_caln_a) THEN BEGIN
      printf, -2, 'Warning: timestamp beyond end of Ahead LET sectored caldb: Using Last Ahead LET sectored factors file'
      sectored_factors_filenm = concat_dir('$LET_L1_CALIB_DATA' , sec_calfnames_a[sec_caln_a -1])
   ENDIF
   IF (SCid ne 234) then BEGIN 
      printf, -2, 'Warning: Bad SCid:', SCid, '   Using Ahead LET sectored factors file'
   ENDIF 
ENDELSE 

IF ( (SCid eq OSCid ) AND (factors_filenm eq offile) ) THEN $
   need_to_read = 0
IF ( (SCid eq OSCid ) AND (sectored_factors_filenm eq osffile) ) THEN $
   sectored_need_to_read = 0

; print, utc2str(tai2utc(tai_time,/NOCORRECT)), "   ", factors_filenm, "   ", need_to_read

OSCid = SCid
offile = factors_filenm
osffile = sectored_factors_filenm

END
