PRO factors_example

; read in the common block.
; Many variables and arrays associated with the factors database are defined there...
common let_l1

      ;  Figure out which calibration factors file is current, based on spacecraftID (234 or 235), 
      ;  and the time in the packet header
         need_to_read = 1
         sectored_need_to_read = 1

      ; dummy values here, just as example
         SCid = 235
         pkt_time = 1571536000.0D
         find_let_factors_files, SCid, pkt_time, factors_filenm, $
                sectored_factors_filenm, need_to_read, sectored_need_to_read

      ; read in the unsectored factors, if necessary  
         IF (need_to_read) then BEGIN
            print, utc2str(tai2utc(pkt_time)), "  ", need_to_read, "  ", factors_filenm
            read_let_factors, factors_filenm
         ENDIF
         
      ; read in the sectored factors, if necessary  
         IF (sectored_need_to_read) then BEGIN
            print, utc2str(tai2utc(pkt_time)), "  ", sectored_need_to_read, "  ", sectored_factors_filenm
            read_let_sectored_factors, sectored_factors_filenm
         ENDIF

END
