
; Return the decompressed LET compressed counter values.  The LET
; counters are compressed using a hidden 1 algorithm with a 12-bit
; mantissa (excluding the hidden bit) and a 4-bit exponent.
;
; Parameters
;   compressed = set of compressed counter values to be decompressed.
 
function decompressLetCounters, compressed

  common let_l1
 
  decompressed = ulong64(compressed) and 'FFFF'XL
  power = ishft(decompressed, -12)
  index = where(power gt 1, count)
  if (count gt 0) then begin
    decompressed[index] = (decompressed[index] and '0fff'X) or '1000'X
    decompressed[index] = ishft(decompressed[index], power[index] - 1)
    decompressed[index] = decompressed[index]            $
                        + ishft(1 , power[index] - 2) - 1
  endif

  index2 = where(decompressed gt 'FFFFFF'X, count)
  if (count gt 0) then $
       decompressed[index2] = ulong64(FILL_L)

  return, long(decompressed)
end
