#!/usr/local/bin/perl -w

### $Id$
### Author: Glenn Hamell
### NAME: yyyydddfmbartels.pl
###
### This software is Copyright (C) 2007,
### ACE Science Center, SRL, California Institute of Technology.
### All rights reserved. Unauthorized reproduction prohibited.
###
### The software is provided to you without charge,
### and with no warranty. You may give away copies of
### this software, including sources, provided that
### this notice is included in all the files.
###
###
### CALLING SEQUENCE:  yyyydddfmbartels.pl <Bartels_number>
###
###	CAUTION: This routine will cough when given numbers < 946 and > 2785
###
### PURPOSE:
###	Return year and DayOfYear <yyyy ddd yyyy ddd> for
###	start and end dates for a given Bartels Rotation Number.
###
### INPUT:
###	Cmdline: Bartels # for which date is required.
###
### OUTPUT:
###	STDOUT
###		date of 1st day & last day of given Bart.Rot.Num.
###		fmt: yyyy ddd yyyy ddd
###
### RETURN:
###	date of 1st day & last day of given Bart.Rot.Num.
###	fmt: yyyy ddd yyyy ddd
###
### MODIFICATION HISTORY:
### =====================
### 2007Jun29-Glenn Hamell Created.Actually a rewrite of
###	an earlier routine.  This version is intended to
###	be more general and uses Date::ExDate to do the
###	hard calendar calcs.
###
###################################################
use strict;
use Date::EzDate;

### CAUTION: This routine will cough for numbers < 946 and > 2785
# Valid range:	Maximum BRN 2785 yields 2037 331 2037 357
#	        Minimum BRN  946 yields 1901 352 1902 013

### Initialization
  my $givenBn = $ARGV[0] ;
  # Known Bartels number starting date (stake-in-the-ground)
  my $baseBn = 2394; # Known Bartels # & starting date (stake-in-the-ground)
  my $date = Date::EzDate->new('January 1, 2009');
  # Calc # of days from base date (neg if earlier, positive if later)
  my $deltaBn = $givenBn - $baseBn ;
  my $deltadays = 27 * $deltaBn ;
  $date += $deltadays ;	# First day of rotation
  print $date->{'year'}," ", $date->{'yeardaybase1'}, " " ;
  $date += 26 ;		# Last day of rotation
  print $date->{'year'}," ", $date->{'yeardaybase1'}, "\n" ;
