#!/usr/local/bin/perl -w
#
# Return the Bartels rotation for given year, day-of-year
#
# A. Davis, Caltech, Feb 2009

use Date::EzDate;

  my ($year, $day) =  @ARGV;

  my $today = Date::EzDate->new('12 pm');
  $today->set_warnings(0);
  $today->{'year'} = $year;
  $today->{'day of year base 1'} = $day;
#  print "$today\n";

  my $bart2394 = $today->clone();
  $bart2394->{'full'} = '12:00:00 pm, January 1, 2009';
#  print "$bart2394\n";
  
  my $diff = $bart2394->{'epoch day'} - $today->{'epoch day'};

#  print "$diff\n";

  if ($diff > 1) {
     $diff--;
  }

  my $nbart = int $diff/27;

  my $pbart = 2394 - $nbart; 

  if ($diff > 0) {
     $pbart--;
  }
  print "$pbart\n";

  exit(0);
