#!/bin/bash
. /home/stereo/Software/procenv

BART=$1
SC=$2
PUBPRI=$3
BEGIN=$4

read SYEAR SDOY EYEAR EDOY < <( ./yyyydddfmbartels.pl $BART )

# echo $BART $SYEAR $SDOY $EYEAR $EDOY

if [ $PUBPRI != "public" -a $PUBPRI != "private" ]; then
   echo Usage: $0 BART SC pubpri, where pubpri is public or private
   exit 1
fi

DATE=`date`

FLAG=0
if [ $PUBPRI == "public" ]; then
   BADBARTFILE=bad_bartels_${SC}.txt
   BADBARTLIST=`cat $BADBARTFILE`
   for bart in $BADBARTLIST
   do
      if [ $bart -eq $BART ]; then
         FLAG=1
	 break
      fi
   done
fi

TMPOUT=./tmpout_$SC

if [ $BEGIN -eq 1 ]; then
   /bin/rm -f $TMPOUT/*.dat
fi

if [ $PUBPRI == "public" ]; then
   WEBDIR=$WEBDATA/Level1/Public/$SC/27day
   SRCDIR=$LETL1PUBDATAHOME/$SC/
   export LEGEND="Public Level 1 Data. $DATE"
else
   WEBDIR=$WEBDATA/Level1/SRLonly/$SC/27day
   SRCDIR=$LETL1SRLONLYDATAHOME/$SC/
   export LEGEND="SRL-only Data - do not distribute. $DATE"
fi

if [ ! -d $WEBDIR ]; then
   mkdir -p $WEBDIR
fi

# LET Level 1 data Version number
L1VERSIONSTR=`$GAWK '($1=="VERSION"){print $3; exit}' $STEREOIDL/LETLevel1/let_l1_common.pro`
L1VERSION=`expr "$L1VERSIONSTR" : '\([0-9]*\)'`
if [ $L1VERSION -lt 10 ]; then L1VERSION=0$L1VERSION; fi
# L1VERSION=08
export L1VERSION

cd $STEREOIDL/LETLevel1/27day_averages

# Generic function to prepare the data, average the data
# SPECIES SPECIESLONG YMIN YMAX must all be set 
function doallthework {
   export SRCNARROW=${SPECIES}_narrow.dat
   export SRCSUMMED=${SPECIES}_summed.dat
   /bin/rm -f $SRCSUMMED $SRCNARROW tmp.dat tmp2.dat
   for (( yr=SYEAR; yr <= EYEAR; yr++ )); do
      SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Summed/${SPECIES}_summed_${SC}_${yr}_1hr_level1_*.txt | tail -1`
      if [ ! -f $SRCFILE ]; then
         if [ $yr -eq $SYEAR ]; then
            echo $0: $SRCFILE does not exist...exiting
            exit 1
         fi
      else
         $BEHEAD $SRCFILE >> tmp.dat
      fi
      SRCFILE=`/bin/ls $SRCDIR/Hourly/$yr/Standard/${SPECIES}_${SC}_${yr}_1hr_level1_*.txt | tail -1`
      if [ ! -f $SRCFILE ]; then
         if [ $yr -eq $SYEAR ]; then
            echo $0: $SRCFILE does not exist...exiting
            exit 1
         fi
      else
         $BEHEAD $SRCFILE >> tmp2.dat
      fi
   done

#   echo $SPECIES $SYEAR $SDOY $EYEAR $EDOY $SC $SRCSUMMED
   ./average_fluxes.bash $SPECIES $SYEAR $SDOY $EYEAR $EDOY $SC ebins_summed.txt tmp.dat $SRCSUMMED $FLAG
   if [ $? -ne 0 ]; then
      echo $0: ERROR: bad exit status from average_fluxes.bash summed
      exit 1
   fi
   ./average_fluxes.bash $SPECIES $SYEAR $SDOY $EYEAR $EDOY $SC ebins_narrow.txt tmp2.dat $SRCNARROW $FLAG
   if [ $? -ne 0 ]; then
      echo $0: ERROR: bad exit status from average_fluxes.bash narrow
      exit 1
   fi

   if [ $BEGIN -eq 1 ]; then
      cp $SRCNARROW $TMPOUT
      cp $SRCSUMMED $TMPOUT
   else
      $BEHEAD $SRCNARROW >> $TMPOUT/$SRCNARROW
      $BEHEAD $SRCSUMMED >> $TMPOUT/$SRCSUMMED
   fi
   if [ $BEGIN -eq 2 ]; then
      cp $TMPOUT/$SRCNARROW $WEBDIR/${SPECIES}_narrow_${SC}.txt
      cp $TMPOUT/$SRCSUMMED $WEBDIR/${SPECIES}_summed_${SC}.txt
   fi
}

# Protons
export SPECIES=H
export SPECIESLONG=Protons
export YMIN=1E-6
export YMAX=1E+5
doallthework

# 3He
export SPECIES=He3
export SPECIESLONG=He3
export YMIN=1E-8
export YMAX=1E+2
# doallthework

# 4He
export SPECIES=He4
export SPECIESLONG=He4
export YMIN=1E-7
export YMAX=1E+3
doallthework

# Helium
export SPECIES=He
export SPECIESLONG=Helium
export YMIN=1E-7
export YMAX=1E+3
doallthework

# C
export SPECIES=C
export SPECIESLONG=Carbon
export YMIN=1E-9
export YMAX=1E+1
doallthework

# N
export SPECIES=N
export SPECIESLONG=Nitrogen
export YMIN=1E-9
export YMAX=1E+1
doallthework

# O
export SPECIES=O
export SPECIESLONG=Oxygen
export YMIN=1E-9
export YMAX=1E+1
doallthework

# Ne
export SPECIES=Ne
export SPECIESLONG=Neon
export YMIN=1E-10
export YMAX=1E+0
doallthework

# Na
export SPECIES=Na
export SPECIESLONG=Sodium
export YMIN=1E-10
export YMAX=1E+0
doallthework

# Mg
export SPECIES=Mg
export SPECIESLONG=Magnesium
export YMIN=1E-10
export YMAX=1E+0
doallthework

# Al
export SPECIES=Al
export SPECIESLONG=Aluminum
export YMIN=1E-10
export YMAX=1E+0
doallthework

# Si
export SPECIES=Si
export SPECIESLONG=Silicon
export YMIN=1E-10
export YMAX=1E+0
doallthework

# S
export SPECIES=S
export SPECIESLONG=Sulfur
export YMIN=1E-10
export YMAX=1E+0
doallthework

# Ar
export SPECIES=Ar
export SPECIESLONG=Argon
export YMIN=1E-10
export YMAX=1E+0
doallthework

# Ca
export SPECIES=Ca
export SPECIESLONG=Calcium
export YMIN=1E-10
export YMAX=1E+0
doallthework

# Fe
export SPECIES=Fe
export SPECIESLONG=Iron
export YMIN=1E-10
export YMAX=1E+0
doallthework

# Ni
export SPECIES=Ni
export SPECIESLONG=Nickel
export YMIN=1E-10
export YMAX=1E+0
doallthework

