#!/bin/bash
# Average LET Hourly fluxes over a period of days

. /home/stereo/Software/procenv

SPECIES=$1
SYEAR=$2
SDOY=$3
SDOY=$((10#$SDOY+0))
EYEAR=$4
EDOY=$5
EDOY=$((10#$EDOY+0))
SC=$6
BINSFILE=$7
SRCFILE=$8
OUTFILE=$9
# if FLAG=1, then this bartels rotation is bad.
FLAG=${10}

$GAWK 'BEGIN{
   fg='$FLAG'; binsfile="'$BINSFILE'"; species="'$SPECIES'"; syear='$SYEAR'; sdoy='$SDOY'; eyear='$EYEAR'; edoy='$EDOY'; sc="'$SC'";
   nbins=0; matched=0;
   while ( getline < binsfile ) 
      if ($1==species) { matched=1; break; }
   if (!matched) exit 1;
   nbins=$2;
   for (i=0; i<nbins;i++) {
      elo[i]=$((i+1)*2 +1); ehi[i]=$((i+1)*2 +2);
      ebin[i] = sqrt(elo[i] * ehi[i]);
      cnt[i] = 0; avg[i]=0; unc[i]=0;
   }
   
}{ \
   if (fg==1) exit;
   if (($1==syear)&&($2<sdoy)) next;
   if (($1==eyear)&&($2>=edoy+1)) exit;
   for (i=0; i<nbins;i++) {
      f_idx=i+7; c_idx=f_idx+(1*nbins);
#      if (i==0) print f_idx, c_idx, $f_idx, $c_idx;
      if ($f_idx >=0) {
         cnt[i]++; avg[i]+=$f_idx;
	 if ($c_idx>0)
	    unc[i]+=($f_idx * $f_idx)/$c_idx;
      }
   }
}END{
   printf("STEREO LET %s %s 27-day averages\nTimestamp marks start of 27-day period\n",sc,species);
   for (i=0; i<nbins;i++) {
      printf("Bin %d Elo Ehi sqrt(Elo*Ehi): %7.3f %7.3f %7.3f\n",i,elo[i],ehi[i],ebin[i]);
   }
   printf("Columns: Year, Doy, %d fluxes, %d statistical uncertainties\n",i,i);
   printf("Units for fluxes and uncertainties: 1/(cm^2 s sr MeV/nuc)\n");
   printf("Uncertainties: U(I) = sqrt ( Sum( Ii^2/Ni ) ) / M, where M is the number of good 1-hour records in the interval\n");
   printf("BEGIN DATA\n%4d %3d ",syear,sdoy);
   for (i=0; i<nbins;i++) {
      if (cnt[i] >0) {
         avg[i] = avg[i]/cnt[i];
	 unc[i] = sqrt(unc[i])/cnt[i];
      }
      else {
         avg[i] = -9999.9; unc[i] = 0.0;
      }
   }
   for (i=0; i<nbins;i++) printf("% 10.4e ",avg[i]);
   for (i=0; i<nbins;i++) printf("% 10.4e ",unc[i]);
   printf("\n");
}' $SRCFILE >> $OUTFILE
